/*
 * Decompiled with CFR 0.152.
 */
package orbital.robotic.strategy;

import java.util.List;
import java.util.ListIterator;
import orbital.robotic.strategy.SelectionImpl;

public interface Selection {
    public Object getWeight();

    public int select(List var1);

    public static final class Selecting {
        public static final Selection sum() {
            return new SelectionImpl(){

                public int select(List weights) {
                    this.weight = 0.0;
                    int selected = -1;
                    double bw = Double.NEGATIVE_INFINITY;
                    ListIterator<E> i = weights.listIterator();
                    while (i.hasNext()) {
                        double w = ((Number)i.next()).doubleValue();
                        if (Double.isNaN(w)) continue;
                        this.weight += w;
                        if (!(w >= bw)) continue;
                        selected = i.previousIndex();
                        bw = w;
                    }
                    if (selected < 0) {
                        this.weight = Double.NaN;
                    }
                    return selected;
                }
            };
        }

        public static final Selection min() {
            return new SelectionImpl(){

                public int select(List weights) {
                    int selected = -1;
                    this.weight = Double.POSITIVE_INFINITY;
                    ListIterator<E> i = weights.listIterator();
                    while (i.hasNext()) {
                        double w = ((Number)i.next()).doubleValue();
                        if (!(w <= this.weight)) continue;
                        selected = i.previousIndex();
                        this.weight = w;
                    }
                    if (selected < 0) {
                        this.weight = Double.NaN;
                    }
                    return selected;
                }
            };
        }

        public static final Selection max() {
            return new SelectionImpl(){

                public int select(List weights) {
                    int selected = -1;
                    this.weight = Double.NEGATIVE_INFINITY;
                    ListIterator<E> i = weights.listIterator();
                    while (i.hasNext()) {
                        double w = ((Number)i.next()).doubleValue();
                        if (!(w >= this.weight)) continue;
                        selected = i.previousIndex();
                        this.weight = w;
                    }
                    if (selected < 0) {
                        this.weight = Double.NaN;
                    }
                    return selected;
                }
            };
        }

        public static final Selection best() {
            return Selecting.max();
        }
    }
}

