/*
 * Decompiled with CFR 0.152.
 */
package orbital.robotic;

import java.io.Serializable;

public class Move
implements Serializable {
    private static final long serialVersionUID = 6779406874030679132L;
    public static final char Rest = ' ';
    public static final char Teleport = '#';
    public static final char Jumping = '_';
    public static final char Sloping = '/';
    public static final char Beating = '*';
    public static final char Right = 'r';
    public static final char RightW = 'R';
    public static final char For = 'f';
    public static final char ForW = 'F';
    public static final char Left = 'l';
    public static final char LeftW = 'L';
    public static final char Back = 'b';
    public static final char BackW = 'B';
    public static final char All = 'a';
    public static final char AllW = 'A';
    public static final char East = 'e';
    public static final char EastW = 'E';
    public static final char North = 'n';
    public static final char NorthW = 'N';
    public static final char West = 'w';
    public static final char WestW = 'W';
    public static final char South = 's';
    public static final char SouthW = 'S';
    private String movement;

    public Move(char mv) {
        this.movement = "" + mv;
    }

    public Move(String mv) {
        this.movement = mv;
    }

    public Move() {
        this(' ');
    }

    public boolean equals(Object o) {
        return o instanceof Move && this.movement.equals(((Move)o).movement);
    }

    public int hashCode() {
        return this.movement.hashCode();
    }

    public final String getMovementString() {
        return this.movement;
    }

    public final int length() {
        return this.movement.length();
    }

    public final boolean isBeating() {
        return this.movement.indexOf(42) >= 0;
    }

    public final boolean isBeating(int istep) {
        if (istep < 0 || istep >= this.movement.length()) {
            return false;
        }
        while (this.movement.charAt(istep) == '_') {
            if (++istep < this.movement.length()) continue;
            return false;
        }
        return this.movement.charAt(istep) == '*';
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.movement + "]";
    }
}

