/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import orbital.logic.functor.BinaryFunction;
import orbital.logic.functor.Function;
import orbital.math.Arithmetic;
import orbital.math.ArithmeticFormat;
import orbital.math.Matrix;
import orbital.math.Real;
import orbital.math.Scalar;
import orbital.math.Symbol;
import orbital.math.Tensor;
import orbital.math.Values;
import orbital.math.Vector;
import orbital.math.functional.Functionals;
import orbital.math.functional.Functions;
import orbital.math.functional.MathFunctor;
import orbital.math.functional.Operations;
import orbital.moon.math.AbstractTensor;
import orbital.moon.math.ArithmeticVector;
import orbital.util.Utility;

abstract class AbstractVector
extends AbstractTensor
implements Vector {
    private static final long serialVersionUID = 372991453454528414L;
    protected transient int modCount = 0;
    private static double DefaultNorm = 2.0;

    AbstractVector() {
    }

    protected abstract Vector newInstance(int var1);

    protected final Tensor newInstance(int[] dim) {
        return dim.length == 1 ? this.newInstance(dim[0]) : Values.getDefaultInstance().newInstance(dim);
    }

    public double getDoubleValue(int i) {
        try {
            return ((Number)((Object)this.get(i))).doubleValue();
        }
        catch (ClassCastException x) {
            throw new UnsupportedOperationException("no real number");
        }
    }

    protected abstract void set(Arithmetic[] var1);

    public Vector subVector(int i1, int i2) {
        return new SubVector(this, i1, i2);
    }

    public ListIterator iterator() {
        return new ListIterator(){
            private int cursor = 0;
            private int lastRet = -1;
            private transient int expectedModCount;
            {
                this.expectedModCount = AbstractVector.this.modCount;
            }

            public boolean hasNext() {
                return this.cursor < AbstractVector.this.dimension();
            }

            public boolean hasPrevious() {
                return this.cursor != 0;
            }

            public Object next() {
                try {
                    Arithmetic next = AbstractVector.this.get(this.cursor);
                    this.checkForComodification();
                    this.lastRet = this.cursor++;
                    return next;
                }
                catch (IndexOutOfBoundsException e) {
                    this.checkForComodification();
                    throw new NoSuchElementException();
                }
            }

            public Object previous() {
                try {
                    Arithmetic previous = AbstractVector.this.get(--this.cursor);
                    this.checkForComodification();
                    this.lastRet = this.cursor;
                    return previous;
                }
                catch (IndexOutOfBoundsException e) {
                    this.checkForComodification();
                    throw new NoSuchElementException();
                }
            }

            public int nextIndex() {
                return this.cursor;
            }

            public int previousIndex() {
                return this.cursor - 1;
            }

            public void remove() {
                if (this.lastRet == -1) {
                    throw new IllegalStateException();
                }
                this.checkForComodification();
                try {
                    AbstractVector.this.remove(this.lastRet);
                    if (this.lastRet < this.cursor) {
                        --this.cursor;
                    }
                    this.lastRet = -1;
                    this.expectedModCount = AbstractVector.this.modCount;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConcurrentModificationException();
                }
            }

            public void set(Object o) {
                if (!(o instanceof Arithmetic)) {
                    throw new IllegalArgumentException();
                }
                if (this.lastRet == -1) {
                    throw new IllegalStateException();
                }
                this.checkForComodification();
                try {
                    AbstractVector.this.set(this.lastRet, (Arithmetic)o);
                    this.expectedModCount = AbstractVector.this.modCount;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConcurrentModificationException();
                }
            }

            public void add(Object o) {
                if (!(o instanceof Arithmetic)) {
                    throw new IllegalArgumentException();
                }
                this.checkForComodification();
                try {
                    AbstractVector.this.insert(this.cursor++, (Arithmetic)o);
                    this.lastRet = -1;
                    this.expectedModCount = AbstractVector.this.modCount;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConcurrentModificationException();
                }
            }

            private final void checkForComodification() {
                if (AbstractVector.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    public Real norm() {
        return this.norm(DefaultNorm);
    }

    public Real norm(double p) {
        if (!(p >= 1.0)) {
            throw new IllegalArgumentException("p-norm defined for p>=1");
        }
        if (p == Double.POSITIVE_INFINITY) {
            return (Real)Operations.sup.apply(Functionals.map(Functions.norm, this));
        }
        return (Real)Operations.power.apply(Operations.sum.apply(Functionals.map((Function)Functions.pow(p), Functionals.map((Function)Functions.norm, this.iterator()))), Values.getDefaultInstance().valueOf(1.0 / p));
    }

    public Arithmetic zero() {
        return Values.getDefaultInstance().ZERO(this.dimension());
    }

    public Arithmetic one() {
        throw new UnsupportedOperationException("vector spaces do not have a 1");
    }

    public Vector add(Vector b) {
        return (Vector)super.add(b);
    }

    public Vector subtract(Vector b) {
        return (Vector)super.subtract(b);
    }

    public Arithmetic multiply(Vector b) {
        Utility.pre(this.dimension() == b.dimension(), "vectors for dot-product must have equal dimension");
        return (Arithmetic)Functionals.foldRight((BinaryFunction)Operations.plus, (Object)Values.ZERO, Functionals.map((BinaryFunction)Operations.times, this.iterator(), b.iterator()));
    }

    public Vector multiply(Scalar s) {
        return this.scale(s);
    }

    public Vector scale(Scalar s) {
        return (Vector)this.scale((Arithmetic)s);
    }

    public Vector multiply(Matrix B) {
        Utility.pre(this.dimension() == B.dimension().height, "column-Vector v.A only defined for column-Vector multiplied with Matrix of same height. " + this.dimension() + "!=" + B.dimension().height);
        Vector ret = this.newInstance(B.dimension().width);
        for (int i = 0; i < ret.dimension(); ++i) {
            ret.set(i, this.multiply(B.getColumn(i)));
        }
        return ret;
    }

    public Arithmetic add(Arithmetic b) {
        return this.add((Vector)b);
    }

    public Arithmetic subtract(Arithmetic b) {
        return this.subtract((Vector)b);
    }

    public Arithmetic multiply(Arithmetic b) {
        if (b instanceof Scalar) {
            return this.scale((Scalar)b);
        }
        if (b instanceof Matrix) {
            return this.multiply((Matrix)b);
        }
        if (b instanceof Vector) {
            return this.multiply((Vector)b);
        }
        if (b instanceof Tensor) {
            return super.multiply((Tensor)b);
        }
        if (b instanceof Symbol || b instanceof MathFunctor) {
            return this.scale(b);
        }
        throw new IllegalArgumentException("wrong type: " + b.getClass());
    }

    public Arithmetic inverse() {
        throw new UnsupportedOperationException("vector space is no field");
    }

    public Arithmetic divide(Arithmetic b) {
        throw new UnsupportedOperationException("vector space is no field");
    }

    public Arithmetic power(Arithmetic b) {
        throw new UnsupportedOperationException("vector space is no field");
    }

    public Vector cross(Vector b) {
        Utility.pre((this.dimension() == 3 || this.dimension() == 2) && this.dimension() == b.dimension(), "domain of cross-product is 3D");
        Vector r = this.newInstance(3);
        if (this.dimension() == 3) {
            r.set(0, this.get(1).multiply(b.get(2)).subtract(this.get(2).multiply(b.get(1))));
            r.set(1, this.get(2).multiply(b.get(0)).subtract(this.get(0).multiply(b.get(2))));
        } else {
            r.set(0, (Arithmetic)Values.ZERO);
            r.set(1, (Arithmetic)Values.ZERO);
        }
        r.set(2, this.get(0).multiply(b.get(1)).subtract(this.get(1).multiply(b.get(0))));
        return r;
    }

    public Matrix transpose() {
        Matrix r = (Matrix)this.newInstance(new int[]{1, this.dimension()});
        r.setRow(0, this);
        return r;
    }

    public Vector insert(int index, Arithmetic v) {
        int i;
        if (index != this.dimension()) {
            this.validate(index);
        }
        Arithmetic[] a = new Arithmetic[this.dimension() + 1];
        for (i = 0; i < index; ++i) {
            a[i] = this.get(i);
        }
        a[index] = v;
        for (i = index; i < this.dimension(); ++i) {
            a[i + 1] = this.get(i);
        }
        this.set(a);
        return this;
    }

    public Vector insertAll(int index, Vector v) {
        int i;
        if (index != this.dimension()) {
            this.validate(index);
        }
        Arithmetic[] a = new Arithmetic[this.dimension() + v.dimension()];
        for (i = 0; i < index; ++i) {
            a[i] = this.get(i);
        }
        for (i = 0; i < v.dimension(); ++i) {
            a[index + i] = v.get(i);
        }
        for (i = index; i < this.dimension(); ++i) {
            a[v.dimension() + i] = this.get(i);
        }
        this.set(a);
        return this;
    }

    public Vector insert(Arithmetic v) {
        return this.insert(this.dimension(), v);
    }

    public Vector insertAll(Vector v) {
        return this.insertAll(this.dimension(), v);
    }

    public Vector remove(int index) {
        int i;
        this.validate(index);
        Arithmetic[] a = new Arithmetic[this.dimension() - 1];
        for (i = 0; i < index; ++i) {
            a[i] = this.get(i);
        }
        for (i = index; i < a.length; ++i) {
            a[i] = this.get(i + 1);
        }
        this.set(a);
        return this;
    }

    public final int rank() {
        return 1;
    }

    public final int[] dimensions() {
        return new int[]{this.dimension()};
    }

    public final Arithmetic get(int[] i) {
        this.valid(i);
        return this.get(i[0]);
    }

    public final void set(int[] i, Arithmetic vi) {
        this.valid(i);
        this.set(i[0], vi);
    }

    public final Tensor subTensor(int[] i, int[] j) {
        this.valid(i);
        this.valid(j);
        return this.subVector(i[0], j[0]);
    }

    public final Tensor add(Tensor b) {
        return this.add((Vector)b);
    }

    public final Tensor subtract(Tensor b) {
        return this.subtract((Vector)b);
    }

    final void validate(int i) {
        if (i < 0) {
            throw new ArrayIndexOutOfBoundsException("index (" + i + ") is negative");
        }
        if (i >= this.dimension()) {
            throw new ArrayIndexOutOfBoundsException("index (" + i + ") out of dimension (" + this.dimension() + ")");
        }
    }

    final void valid(int[] i) {
        if (i.length != this.rank()) {
            throw new ArrayIndexOutOfBoundsException("illegal number of indices (" + i.length + " indices) for tensor of rank " + this.rank());
        }
        this.validate(i[0]);
    }

    public Arithmetic[] toArray() {
        Arithmetic[] a = new Arithmetic[this.dimension()];
        for (int i = 0; i < this.dimension(); ++i) {
            a[i] = this.get(i);
        }
        return a;
    }

    double[] toDoubleArray() {
        double[] a = new double[this.dimension()];
        for (int i = 0; i < this.dimension(); ++i) {
            a[i] = this.getDoubleValue(i);
        }
        return a;
    }

    public String toString() {
        return ArithmeticFormat.getDefaultInstance().format(this);
    }

    private static class SubVector
    extends AbstractVector {
        private static final long serialVersionUID = 1246257328047975917L;
        private final AbstractVector v;
        private final int offset;
        private final int size;
        private transient int expectedModCount = 0;

        public SubVector(AbstractVector v, int i1, int i2) {
            if (i1 > i2) {
                throw new IllegalArgumentException("Ending index " + i2 + " cannot be less than starting index " + i1 + ".");
            }
            v.validate(i1);
            v.validate(i2);
            this.v = v;
            this.offset = i1;
            this.size = i2 - i1 + 1;
            this.expectedModCount = v.modCount;
        }

        protected Vector newInstance(int dim) {
            this.checkForComodification();
            return this.newInstance(dim);
        }

        public final int dimension() {
            this.checkForComodification();
            return this.size;
        }

        public Arithmetic get(int i) {
            this.validate(i);
            this.checkForComodification();
            return this.v.get(i + this.offset);
        }

        public void set(int i, Arithmetic vi) {
            this.validate(i);
            this.checkForComodification();
            this.v.set(i + this.offset, vi);
        }

        protected void set(Arithmetic[] v) {
            if (this.dimension() != v.length) {
                throw new UnsupportedOperationException("sub-vector cannot be altered. clone first");
            }
            this.checkForComodification();
            throw new UnsupportedOperationException("Altering the underlying buffer of a sub-vector is not yet supported");
        }

        public Object clone() {
            this.checkForComodification();
            return new ArithmeticVector(super.toArray());
        }

        private final void checkForComodification() {
            if (this.v.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

