/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import orbital.logic.functor.BinaryFunction;
import orbital.logic.functor.Functionals;
import orbital.math.Arithmetic;
import orbital.math.ArithmeticFormat;
import orbital.math.Euclidean;
import orbital.math.Integer;
import orbital.math.Polynomial;
import orbital.math.Real;
import orbital.math.Symbol;
import orbital.math.Tensor;
import orbital.math.UnivariatePolynomial;
import orbital.math.Values;
import orbital.math.functional.Function;
import orbital.moon.math.AbstractProductArithmetic;

abstract class AbstractUnivariatePolynomial
extends AbstractProductArithmetic
implements UnivariatePolynomial,
Serializable {
    private static final long serialVersionUID = -5253561352164949692L;
    private static final boolean IMPLEMENTATION_KARATSUBA = false;
    transient Arithmetic R_ZERO;
    protected transient int modCount = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean equals(Object o) {
        return o instanceof UnivariatePolynomial && super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected abstract void set(int var1, Arithmetic var2);

    protected abstract UnivariatePolynomial newInstance(int var1);

    protected final Polynomial newInstance(int[] dim) {
        if (dim.length == 1) {
            return this.newInstance(dim[0]);
        }
        throw new InternalError("multinomials not supported in this method");
    }

    public ListIterator iterator() {
        return new ListIterator(){
            private int cursor = 0;
            private int lastRet = -1;
            private transient int expectedModCount;
            {
                this.expectedModCount = AbstractUnivariatePolynomial.this.modCount;
            }

            public boolean hasNext() {
                return this.cursor <= AbstractUnivariatePolynomial.this.degreeValue();
            }

            public boolean hasPrevious() {
                return this.cursor != 0;
            }

            public Object next() {
                try {
                    Arithmetic next = AbstractUnivariatePolynomial.this.get(this.cursor);
                    this.checkForComodification();
                    this.lastRet = this.cursor++;
                    return next;
                }
                catch (IndexOutOfBoundsException e) {
                    this.checkForComodification();
                    throw new NoSuchElementException();
                }
            }

            public Object previous() {
                try {
                    Arithmetic previous = AbstractUnivariatePolynomial.this.get(--this.cursor);
                    this.checkForComodification();
                    this.lastRet = this.cursor;
                    return previous;
                }
                catch (IndexOutOfBoundsException e) {
                    this.checkForComodification();
                    throw new NoSuchElementException();
                }
            }

            public int nextIndex() {
                return this.cursor;
            }

            public int previousIndex() {
                return this.cursor - 1;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object o) {
                if (!(o instanceof Arithmetic)) {
                    throw new IllegalArgumentException();
                }
                if (this.lastRet == -1) {
                    throw new IllegalStateException();
                }
                this.checkForComodification();
                try {
                    AbstractUnivariatePolynomial.this.set(this.lastRet, (Arithmetic)o);
                    this.expectedModCount = AbstractUnivariatePolynomial.this.modCount;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConcurrentModificationException();
                }
            }

            public void add(Object o) {
                throw new UnsupportedOperationException("not implemented (would shift exponents)");
            }

            private final void checkForComodification() {
                if (AbstractUnivariatePolynomial.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
            }
        };
    }

    public Object apply(Object a) {
        final Arithmetic acast = (Arithmetic)a;
        if (acast instanceof Symbol) {
            Arithmetic r = this.get(0);
            Values vf = Values.getDefaultInstance();
            for (int i = 1; i <= this.degreeValue(); ++i) {
                Arithmetic ci = this.get(i);
                r = r.add(ci.multiply(acast.power(vf.valueOf(i))));
            }
            return r;
        }
        return Functionals.banana(this.R_ZERO, new BinaryFunction(){

            public Object apply(Object c, Object b) {
                return ((Arithmetic)c).add(((Arithmetic)b).multiply(acast));
            }
        }, this.iterator());
    }

    public Function derive() {
        Arithmetic[] ai = new Arithmetic[this.degreeValue()];
        if (ai.length == 0) {
            return this;
        }
        Values vf = Values.getDefaultInstance();
        for (int i = 1; i <= this.degreeValue(); ++i) {
            ai[i - 1] = this.get(i).multiply(vf.valueOf(i));
        }
        return vf.polynomial(ai);
    }

    public Function integrate() {
        if (this.degreeValue() < 0) {
            return this;
        }
        Arithmetic[] ai = new Arithmetic[this.degreeValue() + 1 + 1];
        Values vf = Values.getDefaultInstance();
        ai[0] = this.R_ZERO;
        for (int i = 0; i <= this.degreeValue(); ++i) {
            ai[i + 1] = this.get(i).divide(vf.valueOf(i + 1));
        }
        return vf.polynomial(ai);
    }

    public Arithmetic zero() {
        return Values.getDefaultInstance().polynomial(new Arithmetic[]{this.get(0).zero()});
    }

    public Arithmetic one() {
        return Values.getDefaultInstance().polynomial(new Arithmetic[]{this.get(0).one()});
    }

    public Real norm() {
        return this.degreeValue() < 0 ? Values.ZERO : Values.POSITIVE_INFINITY;
    }

    public Arithmetic add(Arithmetic b) {
        return this.addImpl((UnivariatePolynomial)b);
    }

    public Euclidean add(Euclidean b) {
        return this.addImpl((UnivariatePolynomial)b);
    }

    public UnivariatePolynomial add(UnivariatePolynomial b) {
        return this.addImpl(b);
    }

    private UnivariatePolynomial addImpl(UnivariatePolynomial b) {
        Arithmetic[] r;
        block7: {
            int i;
            int mindeg;
            block6: {
                if (this.degreeValue() < 0) {
                    return b;
                }
                if (b.degreeValue() < 0) {
                    return this;
                }
                r = new Arithmetic[Math.max(this.degreeValue(), b.degreeValue()) + 1];
                mindeg = Math.min(this.degreeValue(), b.degreeValue());
                for (i = 0; i <= mindeg; ++i) {
                    r[i] = this.get(i).add(b.get(i));
                }
                if (!$assertionsDisabled && this.degreeValue() > mindeg && b.degreeValue() > mindeg) {
                    throw new AssertionError((Object)("deg(" + this + ")=" + this.degreeValue() + ", deg(" + b + ")=" + b.degreeValue() + " mindeg=" + mindeg + " cannot be greater than both degrees"));
                }
                if (this.degreeValue() <= mindeg) break block6;
                for (i = mindeg + 1; i <= this.degreeValue(); ++i) {
                    r[i] = this.get(i);
                }
                break block7;
            }
            if (b.degreeValue() <= mindeg) break block7;
            for (i = mindeg + 1; i <= b.degreeValue(); ++i) {
                r[i] = b.get(i);
            }
        }
        return this.representative(r);
    }

    public Arithmetic subtract(Arithmetic b) throws ArithmeticException {
        return this.subtractImpl((UnivariatePolynomial)b);
    }

    public Euclidean subtract(Euclidean b) throws ArithmeticException {
        return this.subtractImpl((UnivariatePolynomial)b);
    }

    public UnivariatePolynomial subtract(UnivariatePolynomial b) {
        return this.subtractImpl(b);
    }

    private UnivariatePolynomial subtractImpl(UnivariatePolynomial b) {
        return (UnivariatePolynomial)this.add(b.minus());
    }

    public Arithmetic multiply(Arithmetic b) {
        return this.multiply((UnivariatePolynomial)b);
    }

    public Euclidean multiply(Euclidean b) {
        return this.multiplyImpl((UnivariatePolynomial)b);
    }

    public UnivariatePolynomial multiply(UnivariatePolynomial b) {
        return this.multiplyImpl(b);
    }

    private UnivariatePolynomial multiplyImpl(UnivariatePolynomial b) {
        return this.multiplyImplConvolution(b);
    }

    private UnivariatePolynomial multiplyImplConvolution(UnivariatePolynomial b) {
        if (this.degreeValue() < 0) {
            return this;
        }
        if (b.degreeValue() < 0) {
            return b;
        }
        Arithmetic[] r = new Arithmetic[this.degreeValue() + b.degreeValue() + 1];
        for (int i = 0; i < r.length; ++i) {
            r[i] = this.get(0).multiply(b.get(i));
            for (int k = 1; k <= i; ++k) {
                r[i] = r[i].add(this.get(k).multiply(b.get(i - k)));
            }
        }
        return this.representative(r);
    }

    private UnivariatePolynomial multiplyImplKaratsuba(UnivariatePolynomial poly2) {
        int i;
        if (this.degreeValue() < 0) {
            return this;
        }
        if (poly2.degreeValue() < 0) {
            return poly2;
        }
        int n = Math.max(this.degreeValue(), poly2.degreeValue());
        if (n == 0) {
            return this.representative(new Arithmetic[]{this.get(0).multiply(poly2.get(0))});
        }
        int d = n + 1 >> 1;
        if (!$assertionsDisabled && d != (int)Math.ceil((double)n / 2.0)) {
            throw new AssertionError((Object)("bit optimization works " + d + "==" + (double)n / 2.0));
        }
        n = d << 1;
        UnivariatePolynomial[] alpha = this.split(this, d);
        UnivariatePolynomial[] beta = this.split(poly2, d);
        UnivariatePolynomial ac = alpha[1].multiply(beta[1]);
        UnivariatePolynomial bd = alpha[0].multiply(beta[0]);
        UnivariatePolynomial t = alpha[1].add(alpha[0]).multiply(beta[1].add(beta[0]));
        Arithmetic[] r = new Arithmetic[n + Math.max(ac.degreeValue(), 0) + 1];
        if (!$assertionsDisabled && bd.degreeValue() >= d) {
            throw new AssertionError((Object)"bd.degreeValue() < d required for shift optimized add of distinct coefficients");
        }
        for (i = 0; i < d; ++i) {
            r[i] = bd.get(i);
        }
        if (!$assertionsDisabled && t.degreeValue() + d >= n) {
            throw new AssertionError((Object)("t.degreeValue() + d < n required for shift optimized add of distinct coefficients " + t.degreeValue() + "+" + d + "<" + n + " with " + alpha[0] + "," + alpha[1] + " and " + beta[0] + "," + beta[1] + " and t=" + t));
        }
        if (!$assertionsDisabled && ac.degreeValue() + d >= n) {
            throw new AssertionError((Object)"ac.degreeValue() + d < n required for shift optimized add of distinct coefficients");
        }
        if (!$assertionsDisabled && bd.degreeValue() + d >= n) {
            throw new AssertionError((Object)"bd.degreeValue() + d < n required for shift optimized add of distinct coefficients");
        }
        for (i = d; i < n; ++i) {
            int j = i - d;
            r[i] = t.get(j).subtract(ac.get(j)).subtract(bd.get(j));
        }
        for (i = n; i < r.length; ++i) {
            r[i] = ac.get(i - n);
        }
        if (!$assertionsDisabled && !this.representative(r).equals(this.multiplyImplConvolution(poly2))) {
            throw new AssertionError((Object)"result of polynomial multiplication per Karatsuba and convolution equal");
        }
        return this.representative(r);
    }

    private final UnivariatePolynomial[] split(UnivariatePolynomial p, int s) {
        int i;
        UnivariatePolynomial[] split = new AbstractUnivariatePolynomial[2];
        Arithmetic[] r = new Arithmetic[s];
        for (i = 0; i < r.length; ++i) {
            r[i] = p.get(i);
        }
        split[0] = this.representative(r);
        r = new Arithmetic[Math.max(p.degreeValue() + 1 - s, 0)];
        for (i = 0; i < r.length; ++i) {
            r[i] = p.get(s + i);
        }
        split[1] = this.representative(r);
        return split;
    }

    public Arithmetic divide(Arithmetic b) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("dividing Euclideans is not generally defined");
    }

    public Arithmetic inverse() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("inverse of Euclideans is not generally defined");
    }

    public Euclidean quotient(Euclidean g) {
        return this.quotient((UnivariatePolynomial)g);
    }

    public UnivariatePolynomial quotient(UnivariatePolynomial g) {
        return this.polynomialDivision(this, g, true);
    }

    public Euclidean modulo(Euclidean g) {
        return this.modulo((UnivariatePolynomial)g);
    }

    public UnivariatePolynomial modulo(UnivariatePolynomial g) {
        return this.polynomialDivision(this, g, false);
    }

    private UnivariatePolynomial polynomialDivision(UnivariatePolynomial f, UnivariatePolynomial g, boolean returnQuotient) {
        if (f.degreeValue() < g.degreeValue()) {
            return f;
        }
        if (g.degreeValue() < 0) {
            throw new ArithmeticException("/ by " + g);
        }
        Arithmetic bm = g.get(g.degreeValue());
        Arithmetic[] quotient = new Arithmetic[f.degreeValue() - g.degreeValue() + 1];
        UnivariatePolynomial f0 = f;
        for (int k = quotient.length - 1; k >= 0; --k) {
            Arithmetic ck;
            Arithmetic ai = f0.get(f0.degreeValue());
            quotient[k] = ck = ai.divide(bm);
            if (!(f0 = f0.subtract(this.BASE(ck, k).multiply(g))).norm().equals(Values.ZERO)) continue;
            for (int i = k - 1; i >= 0; --i) {
                quotient[i] = this.R_ZERO;
            }
            break;
        }
        UnivariatePolynomial q = this.representative(quotient);
        if (!$assertionsDisabled && !f.equals(q.multiply(g).add(f0))) {
            throw new AssertionError((Object)("Euclidean degree equation " + f + " = (" + q + ")*(" + g + ") + " + f0));
        }
        if (!$assertionsDisabled && f0.degreeValue() >= 0 && f0.degreeValue() >= g.degreeValue()) {
            throw new AssertionError((Object)("Euclidean degree condition " + f0.degree() + " < " + g.degree() + " or " + f0 + "=0"));
        }
        return returnQuotient ? q : f0;
    }

    private UnivariatePolynomial BASE(Arithmetic s, int k) {
        Arithmetic[] r = new Arithmetic[k + 1];
        for (int i = 0; i < k; ++i) {
            r[i] = this.R_ZERO;
        }
        r[k] = s;
        return Values.getDefaultInstance().polynomial(r);
    }

    private UnivariatePolynomial representative(Arithmetic[] a) {
        int deg;
        for (deg = a.length - 1; deg >= 0 && a[deg].norm().equals(Values.ZERO); --deg) {
        }
        if (deg < 0) {
            return Values.getDefaultInstance().polynomial(new Arithmetic[0]);
        }
        if (!($assertionsDisabled || 0 <= deg && deg < a.length)) {
            throw new AssertionError((Object)("degree " + deg + " is in [0,n]"));
        }
        if (deg == a.length - 1) {
            return Values.getDefaultInstance().polynomial(a);
        }
        Arithmetic[] r = new Arithmetic[deg + 1];
        for (int i = 0; i < r.length; ++i) {
            r[i] = a[i];
        }
        return Values.getDefaultInstance().polynomial(r);
    }

    public Arithmetic[] getCoefficients() {
        if (this.degreeValue() < 0) {
            return new Arithmetic[0];
        }
        Arithmetic[] a = new Arithmetic[this.degreeValue() + 1];
        for (int i = 0; i <= this.degreeValue(); ++i) {
            a[i] = this.get(i);
        }
        return a;
    }

    public String toString() {
        if (!$assertionsDisabled && this.degreeValue() >= 0 && this.get(this.degreeValue()).norm().equals(Values.ZERO)) {
            throw new AssertionError((Object)("definition of degree implies that the degree-th (" + this.degree() + "-th) coefficient (" + this.get(this.degreeValue()) + ") is != 0"));
        }
        return ArithmeticFormat.getDefaultInstance().format(this);
    }

    public Integer degree() {
        return Values.getDefaultInstance().valueOf(this.degreeValue());
    }

    protected final Object productIndexSet(Arithmetic productObject) {
        return this.dimensions();
    }

    protected ListIterator iterator(Arithmetic productObject) {
        return ((Polynomial)productObject).iterator();
    }

    protected final Arithmetic newInstance(Object productIndexSet) {
        return this.newInstance((int[])productIndexSet);
    }

    abstract Tensor tensorViewOfCoefficients();

    public final Object indexSet() {
        return Values.ONE;
    }

    public Iterator indices() {
        if (this.degreeValue() < 0) {
            return Collections.EMPTY_LIST.listIterator();
        }
        ArrayList<Integer> l = new ArrayList<Integer>(this.degreeValue() + 1);
        for (int i = 0; i <= this.degreeValue(); ++i) {
            l.add(Values.getDefaultInstance().valueOf(i));
        }
        return Collections.unmodifiableList(l).listIterator();
    }

    public final int[] dimensions() {
        return new int[]{this.degreeValue()};
    }

    public final Arithmetic get(Arithmetic i) {
        return this.get(((Integer)i).intValue());
    }

    public final Arithmetic get(int[] i) {
        this.valid(i);
        return this.get(i[0]);
    }

    public final void set(int[] i, Arithmetic vi) {
        this.valid(i);
        this.set(i[0], vi);
    }

    public final void set(Arithmetic i, Arithmetic vi) {
        this.set(((Integer)i).intValue(), vi);
    }

    final void valid(int[] i) {
        if (i.length != 1) {
            throw new ArrayIndexOutOfBoundsException("illegal number of indices (" + i.length + " indices) for univariate polynomial");
        }
    }

    public Polynomial add(Polynomial b) {
        return this.add((UnivariatePolynomial)b);
    }

    public Polynomial subtract(Polynomial b) {
        return this.subtract((UnivariatePolynomial)b);
    }

    public Polynomial multiply(Polynomial b) {
        return this.multiply((UnivariatePolynomial)b);
    }

    static {
        $assertionsDisabled = !AbstractUnivariatePolynomial.class.desiredAssertionStatus();
    }
}

