/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.math.BigInteger;
import orbital.math.Arithmetic;
import orbital.math.Euclidean;
import orbital.math.Rational;
import orbital.math.Real;
import orbital.math.Values;
import orbital.math.functional.Operations;
import orbital.moon.math.AbstractRational;

abstract class AbstractInteger
extends AbstractRational
implements orbital.math.Integer {
    private static final long serialVersionUID = -5859818959999970653L;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractInteger() {
    }

    public int compareTo(Object o) {
        if (orbital.math.Integer.isa.apply(o)) {
            long anotherVal;
            long thisVal = this.longValue();
            return thisVal < (anotherVal = ((orbital.math.Integer)o).longValue()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }
        return this.compareToImpl(o);
    }

    public Arithmetic add(Arithmetic b) {
        if (b instanceof orbital.math.Integer) {
            return this.add((orbital.math.Integer)b);
        }
        return (Arithmetic)Operations.plus.apply(this, b);
    }

    public Arithmetic subtract(Arithmetic b) {
        if (b instanceof orbital.math.Integer) {
            return this.subtract((orbital.math.Integer)b);
        }
        return (Arithmetic)Operations.subtract.apply(this, b);
    }

    public Arithmetic multiply(Arithmetic b) {
        if (b instanceof orbital.math.Integer) {
            return this.multiply((orbital.math.Integer)b);
        }
        return (Arithmetic)Operations.times.apply(this, b);
    }

    public Arithmetic divide(Arithmetic b) {
        if (b instanceof orbital.math.Integer) {
            if (!($assertionsDisabled || Integer.MIN_VALUE <= this.longValue() && this.longValue() <= Integer.MAX_VALUE && Integer.MIN_VALUE <= ((orbital.math.Integer)b).longValue() && ((orbital.math.Integer)b).longValue() <= Integer.MAX_VALUE)) {
                throw new AssertionError((Object)"avoid possible loss of precision");
            }
            Values vf = Values.getDefaultInstance();
            return vf.narrow(vf.rational(this.intValue(), ((orbital.math.Integer)b).intValue()));
        }
        return (Arithmetic)Operations.divide.apply(this, b);
    }

    public Arithmetic inverse() {
        if (!($assertionsDisabled || Integer.MIN_VALUE <= this.longValue() && this.longValue() <= Integer.MAX_VALUE)) {
            throw new AssertionError((Object)"possible loss of precision");
        }
        return Values.getDefaultInstance().rational(1, this.intValue());
    }

    public Arithmetic power(Arithmetic b) {
        if (b instanceof orbital.math.Integer) {
            return this.power((orbital.math.Integer)b);
        }
        return (Arithmetic)Operations.power.apply(this, b);
    }

    public final orbital.math.Integer numerator() {
        return this;
    }

    final int numeratorValue() {
        return this.intValue();
    }

    public final orbital.math.Integer denominator() {
        return Values.ONE;
    }

    final int denominatorValue() {
        return 1;
    }

    public final Rational representative() {
        return this;
    }

    public orbital.math.Integer degree() {
        return (orbital.math.Integer)this.norm();
    }

    public Rational add(Rational b) {
        return (Rational)Operations.plus.apply(this, b);
    }

    public Rational subtract(Rational b) {
        return (Rational)Operations.subtract.apply(this, b);
    }

    public Rational multiply(Rational b) {
        return (Rational)Operations.times.apply(this, b);
    }

    public Rational divide(Rational b) {
        return (Rational)Operations.divide.apply(this, b);
    }

    public Rational power(Rational b) {
        return (Rational)Operations.power.apply(this, b);
    }

    static {
        $assertionsDisabled = !AbstractInteger.class.desiredAssertionStatus();
    }

    static class Big
    extends AbstractInteger {
        private static final long serialVersionUID = -5189252512503918277L;
        private BigInteger value;

        public Big(int v) {
            this(BigInteger.valueOf(v));
        }

        public Big(BigInteger v) {
            this.value = v;
        }

        public Object clone() {
            return new Big(this.value);
        }

        public int intValue() {
            return this.value.intValue();
        }

        public double doubleValue() {
            return this.value.doubleValue();
        }

        public Real norm() {
            return Values.getDefaultInstance().valueOf(this.value.abs());
        }

        public orbital.math.Integer add(orbital.math.Integer b) {
            if (b instanceof Big) {
                return new Big(this.value.add(((Big)b).value));
            }
            if (b instanceof Int || b instanceof Long) {
                return new Big(this.value.add(BigInteger.valueOf(b.longValue())));
            }
            return (orbital.math.Integer)Operations.plus.apply(this, b);
        }

        public orbital.math.Integer subtract(orbital.math.Integer b) {
            if (b instanceof Big) {
                return new Big(this.value.subtract(((Big)b).value));
            }
            if (b instanceof Int || b instanceof Long) {
                return new Big(this.value.subtract(BigInteger.valueOf(b.longValue())));
            }
            return (orbital.math.Integer)Operations.subtract.apply(this, b);
        }

        public Arithmetic minus() {
            return new Big(this.value.negate());
        }

        public orbital.math.Integer multiply(orbital.math.Integer b) {
            if (b instanceof Big) {
                return new Big(this.value.multiply(((Big)b).value));
            }
            if (b instanceof Int || b instanceof Long) {
                return new Big(this.value.multiply(BigInteger.valueOf(b.longValue())));
            }
            return (orbital.math.Integer)Operations.times.apply(this, b);
        }

        public Rational power(orbital.math.Integer b) {
            if (b instanceof Big || b instanceof Long) {
                throw new ArithmeticException("exponentation is possibly too big");
            }
            if (b instanceof Int) {
                return b.compareTo(this.zero()) >= 0 ? new Big(this.value.pow(b.intValue())) : Values.getDefault().rational((orbital.math.Integer)this.one(), Values.getDefault().valueOf(this.value.pow(-b.intValue())));
            }
            return (orbital.math.Integer)Operations.power.apply(this, b);
        }

        public orbital.math.Integer quotient(orbital.math.Integer b) {
            if (b instanceof Big) {
                return new Big(this.value.divide(((Big)b).value));
            }
            if (b instanceof Int || b instanceof Long) {
                return new Big(this.value.divide(BigInteger.valueOf(b.longValue())));
            }
            throw new UnsupportedOperationException("opertion cannot be applied on " + this + " and " + b);
        }

        public Euclidean quotient(Euclidean b) {
            return this.quotient((orbital.math.Integer)b);
        }

        public orbital.math.Integer modulo(orbital.math.Integer b) {
            if (b instanceof Big) {
                return new Big(this.value.mod(((Big)b).value));
            }
            if (b instanceof Int || b instanceof Long) {
                return new Big(this.value.mod(BigInteger.valueOf(b.longValue())));
            }
            throw new UnsupportedOperationException("opertion cannot be applied on " + this + " and " + b);
        }

        public Euclidean modulo(Euclidean b) {
            return this.modulo((orbital.math.Integer)b);
        }
    }

    static class Long
    extends AbstractInteger {
        private static final long serialVersionUID = 6559525715511278001L;
        private long value;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Long(long v) {
            this.value = v;
        }

        public Long(Number v) {
            this.value = v.longValue();
        }

        public Object clone() {
            return new Long(this.longValue());
        }

        public long longValue() {
            return this.value;
        }

        public double doubleValue() {
            return this.longValue();
        }

        public Real norm() {
            return Values.getDefaultInstance().valueOf(Math.abs(this.longValue()));
        }

        public orbital.math.Integer add(orbital.math.Integer b) {
            return new Long(this.longValue() + b.longValue());
        }

        public orbital.math.Integer subtract(orbital.math.Integer b) {
            return new Long(this.longValue() - b.longValue());
        }

        public Arithmetic minus() {
            return new Long(-this.value);
        }

        public orbital.math.Integer multiply(orbital.math.Integer b) {
            return new Long(this.longValue() * b.longValue());
        }

        public Rational power(orbital.math.Integer b) {
            if (b instanceof Long || b instanceof Int) {
                return b.compareTo(this.zero()) >= 0 ? new Long((long)Math.pow(this.longValue(), b.longValue())) : Values.getDefault().rational((orbital.math.Integer)this.one(), Values.getDefault().valueOf((long)Math.pow(this.longValue(), -b.longValue())));
            }
            return (orbital.math.Integer)Operations.power.apply(this, b);
        }

        public orbital.math.Integer quotient(orbital.math.Integer b) {
            return new Long(this.longValue() / b.longValue());
        }

        public Euclidean quotient(Euclidean b) {
            return this.quotient((orbital.math.Integer)b);
        }

        public orbital.math.Integer modulo(orbital.math.Integer b) {
            long m = b.longValue();
            long v = this.longValue() % m;
            if (v < 0L) {
                v += m;
            }
            if (!$assertionsDisabled && (v - this.longValue() % m) % m != 0L) {
                throw new AssertionError((Object)"change of canonical representative, only");
            }
            if (!$assertionsDisabled && v < 0L) {
                throw new AssertionError((Object)"nonnegative representative chosen");
            }
            return new Long(v);
        }

        public Euclidean modulo(Euclidean b) {
            return this.modulo((orbital.math.Integer)b);
        }

        static {
            $assertionsDisabled = !(class$orbital$moon$math$AbstractInteger == null ? (class$orbital$moon$math$AbstractInteger = AbstractInteger.class$("orbital.moon.math.AbstractInteger")) : class$orbital$moon$math$AbstractInteger).desiredAssertionStatus();
        }
    }

    static class Int
    extends AbstractInteger {
        private static final long serialVersionUID = -6566214738338401035L;
        private int value;
        static final /* synthetic */ boolean $assertionsDisabled;

        public Int(int v) {
            this.value = v;
        }

        public Int(Number v) {
            this.value = v.intValue();
        }

        public Object clone() {
            return new Int(this.intValue());
        }

        public int intValue() {
            return this.value;
        }

        public double doubleValue() {
            return this.intValue();
        }

        public Real norm() {
            return Values.getDefaultInstance().valueOf(Math.abs(this.intValue()));
        }

        public orbital.math.Integer add(orbital.math.Integer b) {
            if (b instanceof Int) {
                return new Int(this.intValue() + b.intValue());
            }
            if (b instanceof Long) {
                return new Long((long)this.intValue() + b.longValue());
            }
            return (orbital.math.Integer)Operations.plus.apply(this, b);
        }

        public orbital.math.Integer subtract(orbital.math.Integer b) {
            if (b instanceof Int) {
                return new Int(this.intValue() - b.intValue());
            }
            if (b instanceof Long) {
                return new Long((long)this.intValue() - b.longValue());
            }
            return (orbital.math.Integer)Operations.subtract.apply(this, b);
        }

        public Arithmetic minus() {
            return new Int(-this.value);
        }

        public orbital.math.Integer multiply(orbital.math.Integer b) {
            if (b instanceof Int) {
                return new Int(this.intValue() * b.intValue());
            }
            if (b instanceof Long) {
                return new Long((long)this.intValue() * b.longValue());
            }
            return (orbital.math.Integer)Operations.times.apply(this, b);
        }

        public Rational power(orbital.math.Integer b) {
            if (b instanceof Int) {
                return b.compareTo(this.zero()) >= 0 ? new Int((int)Math.pow(this.intValue(), b.intValue())) : Values.getDefault().rational(1, (int)Math.pow(this.intValue(), -b.intValue()));
            }
            if (b instanceof Long) {
                return b.compareTo(this.zero()) >= 0 ? new Long((long)Math.pow(this.intValue(), b.longValue())) : Values.getDefault().rational((orbital.math.Integer)this.one(), Values.getDefault().valueOf((long)Math.pow(this.intValue(), -b.longValue())));
            }
            return (orbital.math.Integer)Operations.power.apply(this, b);
        }

        public orbital.math.Integer quotient(orbital.math.Integer b) {
            return new Int(this.intValue() / b.intValue());
        }

        public Euclidean quotient(Euclidean b) {
            return this.quotient((orbital.math.Integer)b);
        }

        public orbital.math.Integer modulo(orbital.math.Integer b) {
            int m = b.intValue();
            int v = this.intValue() % m;
            if (v < 0) {
                v += m;
            }
            if (!$assertionsDisabled && (v - this.intValue() % m) % m != 0) {
                throw new AssertionError((Object)"change of canonical representative, only");
            }
            if (!$assertionsDisabled && v < 0) {
                throw new AssertionError((Object)"nonnegative representative chosen");
            }
            return new Int(v);
        }

        public Euclidean modulo(Euclidean b) {
            return this.modulo((orbital.math.Integer)b);
        }

        static {
            $assertionsDisabled = !(class$orbital$moon$math$AbstractInteger == null ? (class$orbital$moon$math$AbstractInteger = AbstractInteger.class$("orbital.moon.math.AbstractInteger")) : class$orbital$moon$math$AbstractInteger).desiredAssertionStatus();
        }
    }
}

