/*
 * Decompiled with CFR 0.152.
 */
package orbital.moon.math;

import java.io.Serializable;
import orbital.math.Arithmetic;
import orbital.math.ArithmeticFormat;
import orbital.math.Fraction;
import orbital.math.Integer;
import orbital.math.Real;
import orbital.math.functional.Operations;
import orbital.moon.math.AbstractArithmetic;

class AbstractFraction
extends AbstractArithmetic
implements Fraction,
Serializable {
    private static final long serialVersionUID = 5889020654090355567L;
    private Arithmetic numerator;
    private Arithmetic denominator;

    public AbstractFraction(Arithmetic a) {
        this(a, a.one());
    }

    public AbstractFraction(Arithmetic a, Arithmetic s) {
        this.numerator = a;
        this.denominator = s;
    }

    private AbstractFraction() {
        this(null, null);
    }

    public boolean equals(Object o) {
        if (o instanceof Fraction) {
            Fraction b = (Fraction)o;
            return this.numerator().multiply(b.denominator()).equals(b.numerator().multiply(this.denominator()));
        }
        return false;
    }

    public int hashCode() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public int compareTo(Object o) {
        Fraction b = (Fraction)o;
        Arithmetic ad = this.numerator().multiply(b.denominator());
        if (ad instanceof Comparable) {
            return ((Comparable)((Object)ad)).compareTo(b.numerator().multiply(this.denominator()));
        }
        throw new UnsupportedOperationException("since the underlying integrity domain " + ad.getClass() + " does not support " + Comparable.class);
    }

    public Arithmetic numerator() {
        return this.numerator;
    }

    public Arithmetic denominator() {
        return this.denominator;
    }

    public Real norm() {
        return this.numerator().norm().divide(this.denominator().norm());
    }

    public Arithmetic zero() {
        return new AbstractFraction(this.numerator().zero(), this.denominator().one());
    }

    public Arithmetic one() {
        return new AbstractFraction(this.numerator().one(), this.denominator().one());
    }

    public Arithmetic add(Arithmetic b) {
        if (b instanceof Fraction) {
            return this.add((Fraction)b);
        }
        return (Arithmetic)Operations.plus.apply(this, b);
    }

    public Arithmetic subtract(Arithmetic b) {
        if (b instanceof Fraction) {
            return this.subtract((Fraction)b);
        }
        return (Arithmetic)Operations.subtract.apply(this, b);
    }

    public Arithmetic multiply(Arithmetic b) {
        if (b instanceof Fraction) {
            return this.multiply((Fraction)b);
        }
        return (Arithmetic)Operations.times.apply(this, b);
    }

    public Arithmetic divide(Arithmetic b) {
        if (b instanceof Fraction) {
            return this.divide((Fraction)b);
        }
        return (Arithmetic)Operations.divide.apply(this, b);
    }

    public Arithmetic power(Arithmetic b) {
        if (b instanceof Integer) {
            return this.power_((Integer)b);
        }
        if (b instanceof Fraction) {
            throw new UnsupportedOperationException();
        }
        return (Arithmetic)Operations.power.apply(this, b);
    }

    public Fraction add(Fraction b) {
        Arithmetic s = this.denominator();
        Arithmetic t = b.denominator();
        return new AbstractFraction(t.multiply(this.numerator()).add(s.multiply(b.numerator())), s.multiply(t)).representative();
    }

    public Fraction subtract(Fraction b) {
        return this.add((Fraction)b.minus());
    }

    public Arithmetic minus() {
        return new AbstractFraction(this.numerator().minus(), this.denominator());
    }

    public Fraction multiply(Fraction b) {
        return new AbstractFraction(this.numerator().multiply(b.numerator()), this.denominator().multiply(b.denominator())).representative();
    }

    public Fraction divide(Fraction b) {
        return new AbstractFraction(this.numerator().multiply(b.denominator()), this.denominator().multiply(b.numerator())).representative();
    }

    public Arithmetic inverse() {
        return new AbstractFraction(this.denominator(), this.numerator());
    }

    public Fraction power_(Integer b) {
        return new AbstractFraction(this.numerator().power(b), this.denominator().power(b)).representative();
    }

    public Arithmetic scale(Arithmetic alpha) {
        return new AbstractFraction(this.numerator.scale(alpha), this.denominator()).representative();
    }

    public Fraction representative() {
        return this;
    }

    public String toString() {
        return ArithmeticFormat.getDefaultInstance().format(this);
    }
}

