/*
 * Decompiled with CFR 0.152.
 */
package orbital.game;

import java.io.Serializable;
import java.util.Iterator;
import orbital.game.Field;
import orbital.game.Figure;
import orbital.game.MoveWeighting;
import orbital.robotic.Move;
import orbital.robotic.Position;
import orbital.util.Utility;

public abstract class AdversarySearch {
    public abstract Option solve(Field var1);

    protected Iterator successors(Field state) {
        return state.expand();
    }

    protected abstract boolean isOurLeaguesTurn(Field var1);

    public static class Option
    implements Comparable,
    Serializable {
        private static final long serialVersionUID = -6512650518865382543L;
        private Field state;
        private Position destination;
        private Figure figure;
        private Move move;
        private double utility;

        public Option(Field state, Position destination, Figure figure, Move move, double utility) {
            this.state = state;
            this.destination = destination;
            this.figure = figure;
            this.move = move;
            this.utility = utility;
        }

        public Option(Field state, Position destination, Figure figure, Move move) {
            this(state, destination, figure, move, 0.0);
        }

        public Option(Field state, Figure figure, Move move, Position destination) {
            this(state, destination, figure, move);
        }

        public Option(MoveWeighting.Argument arg) {
            this(arg.field, arg.destination, arg.figure, arg.move, 0.0);
        }

        public Field getState() {
            return this.state;
        }

        protected void setState(Field state) {
            this.state = state;
        }

        public Position getDestination() {
            return this.destination;
        }

        protected void setDestination(Position destination) {
            this.destination = destination;
        }

        public Figure getFigure() {
            return this.figure;
        }

        protected void setFigure(Figure figure) {
            this.figure = figure;
        }

        public Move getMove() {
            return this.move;
        }

        protected void setMove(Move move) {
            this.move = move;
        }

        public double getUtility() {
            return this.utility;
        }

        public void setUtility(double utility) {
            this.utility = utility;
        }

        boolean isNoMove() {
            return this.getFigure() == null && this.getMove() == null && this.getDestination() == null;
        }

        static Option createNoMove(Field field) {
            return new Option(field, null, (Move)null, (Position)null);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Option)) {
                return false;
            }
            Option b = (Option)o;
            return this.utility == b.utility && Utility.equals(this.getState(), b.getState()) && Utility.equals(this.getDestination(), b.getDestination()) && Utility.equals(this.getFigure(), b.getFigure()) && Utility.equals(this.getMove(), b.getMove());
        }

        public int hashCode() {
            long bits = Double.doubleToLongBits(this.utility);
            return Utility.hashCode(this.getState()) ^ Utility.hashCode(this.getDestination()) ^ Utility.hashCode(this.getFigure()) ^ Utility.hashCode(this.getMove()) ^ (int)(bits ^ bits >>> 32);
        }

        public int compareTo(Object o) {
            return new Double(this.getUtility()).compareTo(new Double(((Option)o).getUtility()));
        }

        public String toString() {
            return "[" + this.figure.x + "|" + this.figure.y + "--" + this.move.getMovementString() + "-->" + this.destination.x + "|" + this.destination.y + "]";
        }
    }
}

