/*
 * Decompiled with CFR 0.152.
 */
package orbital.awt;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import orbital.logic.functor.Function;
import orbital.moon.awt.DefaultCustomizer;
import orbital.util.InnerCheckedException;

public class CustomizerViewController
extends MouseAdapter
implements MouseListener {
    private Frame parent;
    private String title;
    private static Function defaultCustomizerFactory;

    public CustomizerViewController(Frame parent, String title) {
        this.parent = parent;
        this.title = title;
    }

    public CustomizerViewController(Frame parent) {
        this(parent, null);
    }

    public Frame getParent() {
        return this.parent;
    }

    public void setParent(Frame p) {
        this.parent = p;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public static final void setDefaultCustomizerFactory(Function newDefaultCustomizerFactory) {
        defaultCustomizerFactory = newDefaultCustomizerFactory != null ? newDefaultCustomizerFactory : new Function(){

            public Object apply(Object beanClass) {
                try {
                    return new DefaultCustomizer((Class)beanClass);
                }
                catch (IntrospectionException e) {
                    throw new InnerCheckedException("Introspection for Customizer failed: " + e.getMessage(), e);
                }
            }
        };
    }

    private static final Function getDefaultCustomizerFactory() {
        return defaultCustomizerFactory;
    }

    public void showCustomizer(Object bean, String displayName) {
        if (bean instanceof Object[]) {
            this.showCustomizer((Object[])bean, displayName);
            return;
        }
        try {
            Class<?> beanClass = bean.getClass();
            Customizer custom = CustomizerViewController.customizerFor(beanClass);
            custom.setObject(bean);
            BeanInfo info = Introspector.getBeanInfo(beanClass, 1);
            BeanDescriptor desc = info.getBeanDescriptor();
            this.showCustomizer((Component)((Object)custom), (String)(displayName != null ? displayName : (desc == null ? null : desc.getDisplayName())));
        }
        catch (IntrospectionException e) {
            throw new InnerCheckedException("Introspection for Customizer failed: " + e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new ClassCastException("Customizer for bean " + bean.getClass() + " is invalid: " + e.getMessage());
        }
    }

    public void showCustomizer(Object bean) {
        this.showCustomizer(bean, null);
    }

    private void showCustomizer(Object[] bean, String displayName) {
        JTabbedPane tab = new JTabbedPane();
        for (int i = 0; i < bean.length; ++i) {
            if (bean[i] == null) {
                tab.addTab("<Unknown>", new JPanel());
                continue;
            }
            try {
                Class<?> beanClass = bean[i].getClass();
                Customizer custom = CustomizerViewController.customizerFor(beanClass);
                custom.setObject(bean[i]);
                BeanInfo info = Introspector.getBeanInfo(beanClass, 1);
                BeanDescriptor desc = info.getBeanDescriptor();
                tab.addTab(desc == null ? null : desc.getDisplayName(), (Component)((Object)custom));
                continue;
            }
            catch (IntrospectionException e) {
                throw new InnerCheckedException("Introspection for Customizer failed: " + e.getMessage(), e);
            }
            catch (ClassCastException e) {
                throw new ClassCastException("Customizer for bean " + bean.getClass() + " is invalid: " + e.getMessage());
            }
        }
        tab.setSelectedIndex(0);
        this.showCustomizer(tab, displayName);
    }

    public void showCustomizer(Component custom, String displayName) {
        JOptionPane.showMessageDialog(this.parent, custom, this.title != null ? this.title : "Customize " + displayName, -1);
    }

    public static final Customizer customizerFor(Class beanClass) throws IntrospectionException {
        try {
            BeanInfo info = Introspector.getBeanInfo(beanClass, 1);
            if (info == null) {
                throw new NullPointerException("no BeanInfo for class: " + beanClass);
            }
            BeanDescriptor desc = info.getBeanDescriptor();
            if (desc == null) {
                throw new NullPointerException("no BeanDescriptor for class: " + beanClass);
            }
            Class<?> customizerClass = desc.getCustomizerClass();
            if (customizerClass != null) {
                return (Customizer)customizerClass.newInstance();
            }
            return (Customizer)CustomizerViewController.getDefaultCustomizerFactory().apply(beanClass);
        }
        catch (InstantiationException x) {
            throw new IntrospectionException("Customizer could not be instantiated: " + x.getMessage());
        }
        catch (IllegalAccessException x) {
            throw new IntrospectionException("Illegal access to Customizer: " + x.getMessage());
        }
        catch (ClassCastException x) {
            throw new ClassCastException("Customizer for bean is invalid " + x.getMessage());
        }
    }

    public void mouseClicked(MouseEvent e) {
        if ((e.getModifiers() & 0x10) == 16 && e.getClickCount() == 2) {
            this.showCustomizer(e.getComponent());
        }
    }

    static {
        CustomizerViewController.setDefaultCustomizerFactory(null);
    }
}

