/*
 * Decompiled with CFR 0.152.
 */
package orbital.algorithm;

import java.util.Arrays;
import java.util.NoSuchElementException;
import orbital.algorithm.Combinatorical;
import orbital.math.Integer;
import orbital.math.MathUtilities;
import orbital.math.Values;
import orbital.math.functional.Operations;
import orbital.util.SuspiciousError;
import orbital.util.Utility;

class GeneralizedPermutation
extends Combinatorical {
    private static final long serialVersionUID = 6710387882794688842L;
    private final int[] dimensions;
    private int[] index;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GeneralizedPermutation(int[] dimensions) {
        this.dimensions = dimensions;
        this.index = this.zero();
    }

    public boolean hasNext() {
        for (int k = this.index.length - 1; k >= 0; --k) {
            if (this.index[k] < this.dimensions[k]) continue;
            return false;
        }
        return true;
    }

    public int[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int[] r = (int[])this.index.clone();
        for (int k = this.index.length - 1; k >= 0; --k) {
            int n = k;
            this.index[n] = this.index[n] + 1;
            if (this.index[k] == this.dimensions[k]) {
                this.index[k] = 0;
                continue;
            }
            if (this.index[k] > this.dimensions[k]) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)(NoSuchElementException.class + " should already have occurred"));
                }
                continue;
            }
            if (this.index[k] < this.dimensions[k]) {
                return r;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
        if (this.index.length == 0) {
            return r;
        }
        if (!$assertionsDisabled && !Utility.equalsAll(this.index, this.zero())) {
            throw new AssertionError((Object)"rotated back to 0");
        }
        for (int i = 0; i < this.index.length; ++i) {
            this.index[i] = this.dimensions[i] - 1;
        }
        int n = this.index.length - 1;
        this.index[n] = this.index[n] + 1;
        return r;
    }

    public boolean hasPrevious() {
        for (int k = this.index.length - 1; k >= 0; --k) {
            if (this.index[k] - 1 < 0) continue;
            return true;
        }
        return false;
    }

    public int[] previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        for (int k = this.index.length - 1; k >= 0; --k) {
            int n = k;
            this.index[n] = this.index[n] - 1;
            if (this.index[n] >= 0) {
                return this.index;
            }
            this.index[k] = this.dimensions[k] - 1;
        }
        if (this.index.length == 0) {
            return this.index;
        }
        throw new SuspiciousError();
    }

    public int count() {
        return ((Integer)Operations.product.apply(Values.getDefaultInstance().valueOf(this.dimensions))).intValue();
    }

    public String toString() {
        return this.getClass().getName() + "[of " + MathUtilities.format(this.dimensions) + " elements]";
    }

    private int[] zero() {
        int[] zero = new int[this.dimensions.length];
        Arrays.fill(zero, 0);
        return zero;
    }

    static {
        $assertionsDisabled = !GeneralizedPermutation.class.desiredAssertionStatus();
    }
}

