/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import orbital.game.Field;
import orbital.game.Figure;
import orbital.logic.functor.Predicate;
import orbital.robotic.Position;
import orbital.util.Setops;
import orbital.util.Utility;

class JointAttackCoordinator
implements Serializable {
    private static final long serialVersionUID = -4672427618040960746L;
    private RhythmomachiaFigure attackTarget = null;
    private List attackSource = new LinkedList();
    private int targetRating = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JointAttackCoordinator() {
    }

    JointAttackCoordinator(JointAttackCoordinator jointAttackCoordinator, Field field) {
    }

    void init(JointAttackCoordinator jointAttackCoordinator, RhythmomachiaField rhythmomachiaField) {
        if (!$assertionsDisabled && !this.validateResponsibleFor(rhythmomachiaField)) {
            throw new AssertionError();
        }
        if (jointAttackCoordinator.getTarget() != null || !jointAttackCoordinator.getSources().isEmpty()) {
            if (!$assertionsDisabled && (jointAttackCoordinator.getTarget() == null || jointAttackCoordinator.getSources().isEmpty())) {
                throw new AssertionError((Object)"");
            }
            this.setTarget((RhythmomachiaFigure)rhythmomachiaField.getFigure(jointAttackCoordinator.getTarget()));
            Iterator iterator = jointAttackCoordinator.getSources().iterator();
            while (iterator.hasNext()) {
                Figure figure = (Figure)iterator.next();
                if (!$assertionsDisabled && figure == null) {
                    throw new AssertionError((Object)("during attack of " + jointAttackCoordinator.getTarget() + ", source " + jointAttackCoordinator.getSources() + " does not contain null"));
                }
                Figure figure2 = rhythmomachiaField.getFigure(figure);
                if (!$assertionsDisabled && figure2 == null) {
                    throw new AssertionError((Object)("assume that during attack of " + jointAttackCoordinator.getTarget() + ", source " + jointAttackCoordinator.getSources() + ", " + rhythmomachiaField + " contains " + figure));
                }
                this.add((RhythmomachiaFigure)figure2);
            }
        }
    }

    public RhythmomachiaFigure getTarget() {
        return this.attackTarget;
    }

    private void setTarget(RhythmomachiaFigure rhythmomachiaFigure) {
        this.attackTarget = rhythmomachiaFigure;
    }

    private synchronized List getSources() {
        return Collections.unmodifiableList(this.attackSource);
    }

    private synchronized void add(RhythmomachiaFigure rhythmomachiaFigure) {
        if (!$assertionsDisabled && !this.validate(rhythmomachiaFigure)) {
            throw new AssertionError();
        }
        this.attackSource.add(rhythmomachiaFigure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartAttack() {
        RhythmomachiaFigure rhythmomachiaFigure;
        JointAttackCoordinator jointAttackCoordinator = this;
        synchronized (jointAttackCoordinator) {
            rhythmomachiaFigure = this.getTarget();
            this.attackSource.clear();
            if (rhythmomachiaFigure != null) {
                rhythmomachiaFigure.setRating(this.targetRating);
            }
            this.targetRating = 0;
            this.setTarget(null);
        }
        Game.logger.log(Level.FINE, "restart attack from old target {0}", JointAttackCoordinator.clone(rhythmomachiaFigure));
        if (rhythmomachiaFigure != null) {
            rhythmomachiaFigure.getField().setFigure(rhythmomachiaFigure, rhythmomachiaFigure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aimAttack(RhythmomachiaFigure rhythmomachiaFigure) {
        JointAttackCoordinator jointAttackCoordinator = this;
        synchronized (jointAttackCoordinator) {
            this.setTarget(rhythmomachiaFigure);
            this.targetRating = this.getTarget().getRating();
        }
    }

    public void move(RhythmomachiaFigure rhythmomachiaFigure, Position position) {
        if (rhythmomachiaFigure == null) {
            throw new NullPointerException("illegal arguments");
        }
        if (!$assertionsDisabled && !this.validate(rhythmomachiaFigure)) {
            throw new AssertionError();
        }
        if (this.getSources().contains(rhythmomachiaFigure)) {
            Game.logger.log(Level.FINE, "break attack due to move {0} ---> {1}", new Object[]{JointAttackCoordinator.clone(rhythmomachiaFigure), JointAttackCoordinator.clone(position)});
            this.restartAttack();
        } else {
            Game.logger.log(Level.FINE, "do not break attack due to move {0} ---> {1} in joint attack {2}\nat {3} coord at {4}", new Object[]{JointAttackCoordinator.clone(rhythmomachiaFigure), JointAttackCoordinator.clone(position), this.getSources(), new Integer(System.identityHashCode(this.attackSource)), new Integer(System.identityHashCode(this))});
        }
    }

    public boolean attack(RhythmomachiaFigure rhythmomachiaFigure, RhythmomachiaFigure rhythmomachiaFigure2, boolean bl, boolean bl2) {
        int n;
        if (rhythmomachiaFigure == null || rhythmomachiaFigure2 == null) {
            throw new NullPointerException("illegal arguments");
        }
        if (!$assertionsDisabled && rhythmomachiaFigure.getLeague() == rhythmomachiaFigure2.getLeague()) {
            throw new AssertionError((Object)("can't attack ally " + rhythmomachiaFigure + " --> " + rhythmomachiaFigure2));
        }
        if (!$assertionsDisabled && rhythmomachiaFigure.getField().getTurn() != rhythmomachiaFigure.getLeague()) {
            throw new AssertionError((Object)"it's my turn");
        }
        if (!$assertionsDisabled && !this.validate(rhythmomachiaFigure)) {
            throw new AssertionError();
        }
        if (!rhythmomachiaFigure2.equals(this.attackTarget)) {
            if (this.attackTarget != null) {
                Game.logger.log(Level.FINE, "change target to {0}", JointAttackCoordinator.clone(this.attackTarget));
            }
            this.restartAttack();
            this.aimAttack(rhythmomachiaFigure2);
        }
        if (this.getSources().contains(rhythmomachiaFigure)) {
            Game.game.showStatus(Game.game.getResources().getString("statusbar.move.duplicateAttack"));
            throw new IllegalArgumentException("illegal attack: source " + rhythmomachiaFigure + " used twice in joint attack against " + this.getTarget() + " lead by " + this.getSources());
        }
        int n2 = rhythmomachiaFigure.getDistanceTo(rhythmomachiaFigure2);
        boolean bl3 = false;
        if (rhythmomachiaFigure.getMoveDistance() == n2) {
            ResourceBundle resourceBundle = Game.game.getResources();
            if ((bl && rhythmomachiaFigure.getRating() == -this.attackTarget.getRating() || !bl && rhythmomachiaFigure.getRating() == this.attackTarget.getRating()) && RhythmomachiaRules.curRules.getDirectConfrontation() > 0) {
                Game.logger.log(Level.FINER, "direct confrontation would smash {0} when attacked by {1}", new Object[]{JointAttackCoordinator.clone(rhythmomachiaFigure), JointAttackCoordinator.clone(this.attackTarget)});
                bl3 = this.getSources().isEmpty() || RhythmomachiaRules.curRules.getDirectConfrontation() != 1;
            }
        }
        Game.logger.log(Level.FINE, "attack {0} from {1} along with joint attack {2}\nat {3} coord at {4}", new Object[]{JointAttackCoordinator.clone(this.attackTarget), JointAttackCoordinator.clone(rhythmomachiaFigure), new ArrayList(this.getSources()), new Integer(System.identityHashCode(this.attackSource)), new Integer(System.identityHashCode(this))});
        this.add(rhythmomachiaFigure);
        Game.logger.log(Level.FINE, "RES attack {0} from {1} along with joint attack {2}\nat {3} coord at {4}", new Object[]{JointAttackCoordinator.clone(this.attackTarget), JointAttackCoordinator.clone(rhythmomachiaFigure), new ArrayList(this.getSources()), new Integer(System.identityHashCode(this.attackSource)), new Integer(System.identityHashCode(this))});
        if (bl3) {
            n = rhythmomachiaFigure.getRating();
        } else if (bl2) {
            n = rhythmomachiaFigure.getRating() * n2;
        } else if (rhythmomachiaFigure.getRating() % n2 == 0) {
            n = rhythmomachiaFigure.getRating() / n2;
        } else {
            throw new IllegalArgumentException("illegal attack: indivisible");
        }
        if (bl) {
            this.attackTarget.setRating(this.attackTarget.getRating() + n);
        } else {
            this.attackTarget.setRating(this.attackTarget.getRating() - n);
        }
        if (this.attackTarget.getRating() == 0) {
            this.restartAttack();
            return true;
        }
        return false;
    }

    private final boolean validate(RhythmomachiaFigure rhythmomachiaFigure) {
        return this.validateResponsibleFor((RhythmomachiaField)rhythmomachiaFigure.getField()) && this.validateOnSameField(rhythmomachiaFigure);
    }

    private final boolean validateOnSameField(final RhythmomachiaFigure rhythmomachiaFigure) {
        if (!$assertionsDisabled && !Setops.all(this.getSources(), new Predicate(){

            public boolean apply(Object object) {
                return ((RhythmomachiaFigure)object).getField() == rhythmomachiaFigure.getField();
            }
        })) {
            throw new AssertionError((Object)"all figures are on the same board (sources)");
        }
        if (!$assertionsDisabled && this.getTarget() != null && this.getTarget().getField() != rhythmomachiaFigure.getField()) {
            throw new AssertionError((Object)"all figures are on the same board (also target)");
        }
        return true;
    }

    private final boolean validateResponsibleFor(RhythmomachiaField rhythmomachiaField) {
        if (!$assertionsDisabled && !Utility.containsIdenticalTo(rhythmomachiaField.getCoordinators(), this)) {
            throw new AssertionError((Object)("we only get called for fields that we manage " + System.identityHashCode(rhythmomachiaField) + " " + rhythmomachiaField + "\n" + this + " in " + rhythmomachiaField.getCoordinators() + " in " + rhythmomachiaField.getTurn()));
        }
        return true;
    }

    private static Object clone(RhythmomachiaFigure rhythmomachiaFigure) {
        return rhythmomachiaFigure == null ? null : rhythmomachiaFigure.clone();
    }

    private static Object clone(Position position) {
        return position == null ? null : position.clone();
    }

    static {
        $assertionsDisabled = !JointAttackCoordinator.class.desiredAssertionStatus();
    }
}

