/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.SoftBevelBorder;
import orbital.game.FieldChangeEvent;
import orbital.game.FieldChangeListener;

class ControlPanel
extends JPanel
implements FieldChangeListener {
    private JPanel attackTypePanel;
    private JRadioButton attackTypePlus;
    private JRadioButton attackTypeMinus;
    private JPanel combatValuePanel;
    private JRadioButton combatValueMultiply;
    private JRadioButton combatValueDivide;

    public ControlPanel() {
        JRadioButton jRadioButton;
        this.setLayout(new FlowLayout());
        ResourceBundle resourceBundle = Game.game.getResources();
        Dimension dimension = new Dimension(20, 1);
        Dimension dimension2 = new Dimension(10, 1);
        this.attackTypePanel = this.createHorizontalPanel(false);
        this.attackTypePanel.setBorder(new LineBorder(Color.black, 1, true));
        this.add(this.attackTypePanel);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.attackTypeMinus = jRadioButton = this.createRadioButton("minus", !this.getJointAttackSettings().isAdding());
        jRadioButton.setForeground(Color.white);
        jRadioButton.setFocusPainted(false);
        jRadioButton.setBorderPainted(false);
        jRadioButton.setContentAreaFilled(false);
        jRadioButton.setMargin(new Insets(0, 0, 0, 0));
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.getJointAttackSettings().setAdding(false);
            }
        });
        buttonGroup.add(jRadioButton);
        this.attackTypePanel.add(jRadioButton);
        this.attackTypePanel.add(Box.createRigidArea(dimension2));
        this.attackTypePlus = jRadioButton = this.createRadioButton("plus", this.getJointAttackSettings().isAdding());
        jRadioButton.setForeground(Color.white);
        jRadioButton.setFocusPainted(false);
        jRadioButton.setBorderPainted(false);
        jRadioButton.setContentAreaFilled(false);
        jRadioButton.setMargin(new Insets(0, 0, 0, 0));
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.getJointAttackSettings().setAdding(true);
            }
        });
        buttonGroup.add(jRadioButton);
        this.attackTypePanel.add(jRadioButton);
        this.add(Box.createRigidArea(dimension));
        this.combatValuePanel = this.createHorizontalPanel(false);
        this.combatValuePanel.setBorder(new LineBorder(Color.black, 1, true));
        this.add(this.combatValuePanel);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.combatValueMultiply = jRadioButton = this.createRadioButton("multiply", this.getJointAttackSettings().isMultiplying());
        jRadioButton.setForeground(Color.white);
        jRadioButton.setFocusPainted(false);
        jRadioButton.setBorderPainted(false);
        jRadioButton.setContentAreaFilled(false);
        jRadioButton.setMargin(new Insets(0, 0, 0, 0));
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.getJointAttackSettings().setMultiplying(true);
            }
        });
        buttonGroup2.add(jRadioButton);
        this.combatValuePanel.add(jRadioButton);
        this.combatValuePanel.add(Box.createRigidArea(dimension2));
        this.combatValueDivide = jRadioButton = this.createRadioButton("divide", !this.getJointAttackSettings().isMultiplying());
        jRadioButton.setForeground(Color.white);
        jRadioButton.setFocusPainted(false);
        jRadioButton.setBorderPainted(false);
        jRadioButton.setContentAreaFilled(false);
        jRadioButton.setMargin(new Insets(0, 0, 0, 0));
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.getJointAttackSettings().setMultiplying(false);
            }
        });
        buttonGroup2.add(jRadioButton);
        this.combatValuePanel.add(jRadioButton);
        this.add(Box.createRigidArea(dimension));
        JButton jButton = new JButton(resourceBundle.getString("button.abortAttack.label"));
        this.add(jButton);
        jButton.setToolTipText(resourceBundle.getString("button.abortAttack.tooltip"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.getJointAttackCoordinator().restartAttack();
            }
        });
        jButton = new JButton(resourceBundle.getString("button.endTurn.label"));
        this.add(jButton);
        jButton.setToolTipText(resourceBundle.getString("button.endTurn.tooltip"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((RhythmomachiaField)Game.game.getGameboard().getField()).doTurn(4096);
            }
        });
    }

    private JPanel createHorizontalPanel(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        if (bl) {
            jPanel.setBorder(new CompoundBorder(new SoftBevelBorder(1), new EmptyBorder(5, 5, 5, 5)));
        }
        return jPanel;
    }

    private JRadioButton createRadioButton(String string, boolean bl) {
        ResourceBundle resourceBundle = Game.game.getResources();
        JRadioButton jRadioButton = new JRadioButton(resourceBundle.getString("button." + string + ".label"), new ImageIcon(this.getClass().getResource(resourceBundle.getString("button." + string + ".icon"))), bl);
        jRadioButton.setToolTipText(resourceBundle.getString("button." + string + ".tooltip"));
        jRadioButton.setPressedIcon(new ImageIcon(this.getClass().getResource(resourceBundle.getString("button." + string + ".icon.pressed"))));
        jRadioButton.setRolloverIcon(new ImageIcon(this.getClass().getResource(resourceBundle.getString("button." + string + ".icon.rollover"))));
        jRadioButton.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource(resourceBundle.getString("button." + string + ".icon.rollover.selected"))));
        jRadioButton.setSelectedIcon(new ImageIcon(this.getClass().getResource(resourceBundle.getString("button." + string + ".icon.selected"))));
        return jRadioButton;
    }

    public void componentChanged(FieldChangeEvent fieldChangeEvent) {
    }

    public void movePerformed(FieldChangeEvent fieldChangeEvent) {
    }

    public void stateChanged(FieldChangeEvent fieldChangeEvent) {
        int n = fieldChangeEvent.getField().getTurn();
        this.setBackground(RhythmomachiaRules.leagueColor[n]);
        JointAttackSettings jointAttackSettings = Game.game.getJointAttackSettings(n);
        (jointAttackSettings.isAdding() ? this.attackTypePlus : this.attackTypeMinus).setSelected(true);
        (jointAttackSettings.isMultiplying() ? this.combatValueMultiply : this.combatValueDivide).setSelected(true);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.attackTypePanel != null) {
            this.attackTypePanel.setBackground(color);
        }
        if (this.combatValuePanel != null) {
            this.combatValuePanel.setBackground(color);
        }
    }

    JointAttackSettings getJointAttackSettings() {
        return Game.game.getGameboard() != null ? Game.game.getJointAttackSettings(Game.game.getGameboard().getField().getTurn()) : new JointAttackSettings();
    }

    JointAttackCoordinator getJointAttackCoordinator() {
        return ((RhythmomachiaField)Game.game.getGameboard().getField()).getCoordinator();
    }
}

